USE [msdb]
GO

/****** Object:  Job [Chargoon]    Script Date: 02/17/2016 07:31:43 . ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [Data Collector]    Script Date: 02/17/2016 07:31:43 . ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'Data Collector' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'Data Collector'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'Chargoon', 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'Provides Chargoon compatible data from tblInOutData of Paliz Afzar dbDataCenter', 
		@category_name=N'Data Collector', 
		@owner_login_name=N'sa', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [CreateTable]    Script Date: 02/17/2016 07:31:44 . ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'CreateTable', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[Chargoon]'') AND type in (N''U''))
BEGIN
CREATE TABLE [dbo].[Chargoon](
	[RecordID] [int] IDENTITY(1,1) NOT NULL,
	[CardNo] [varchar](16) NULL,
	[DeviceCode] [int] NULL,
	[Year] [int] NULL,
	[Month] [int] NULL,
	[Day] [int] NULL,
	[Hour] [int] NULL,
	[Minute] [int] NULL,
 CONSTRAINT [PK_Chargoon] PRIMARY KEY CLUSTERED 
(
	[RecordID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N''[dbo].[DF_Chargoon_DeviceCode]'') AND type = ''D'')
BEGIN
ALTER TABLE [dbo].[Chargoon] ADD  CONSTRAINT [DF_Chargoon_DeviceCode]  DEFAULT ((33)) FOR [DeviceCode]
END', 
		@database_name=N'dbDataCenter', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Insert]    Script Date: 02/17/2016 07:31:44 . ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Insert', 
		@step_id=2, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'DECLARE @Temp TABLE
(
	[CardID] bigint,
	[Date] int,
	[Time] int,
	[ReadCounter] tinyint
);

INSERT INTO @Temp ([CardID], [Date], [Time], [ReadCounter])
SELECT dbo.tblInOutData.[CardID], dbo.tblInOutData.[Date], dbo.tblInOutData.[Time], dbo.tblInOutData.[ReadCounter]
FROM            dbo.tblInOutData WHERE dbo.tblInOutData.ReadCounter=0;

UPDATE dbo.tblInOutData SET ReadCounter=1 FROM dbo.tblInOutData INNER JOIN @Temp as T ON dbo.tblInOutData.CardID=T.CardID AND dbo.tblInOutData.[Date]=T.[Date] AND dbo.tblInOutData.[Time]=T.[Time];

INSERT INTO Chargoon (CardNo,[Year],[Month],[Day],[Hour],[Minute])
SELECT CAST(T.CardID AS VARCHAR(16)) AS CardNo, 2000+ T.[Date]/10000 AS [Year], (T.[Date]%10000)/100
                         AS [Month], T.[Date]%100 AS [Day], T.[Time]/10000  AS [Hour], (T.[Time]%10000)/100 AS Minute
FROM            @Temp AS T;', 
		@database_name=N'dbDataCenter', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Main', 
		@enabled=1, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=4, 
		@freq_subday_interval=10, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20160101, 
		@active_end_date=99991231, 
		@active_start_time=0, 
		@active_end_time=235959, 
		@schedule_uid=N'd92f3511-809c-4b1f-813c-748bc58f6345'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:

GO


